define([
    'underscore',
    'models/abstract-collection',
    'modules/new-appointment-request/resources/direct/clinics/model',
    'User',
], function(_, Collection, Model, user) {
    'use strict';


    return Collection.extend({
        resourceName: 'clinic-list',
        model: Model,

        url: function() {
            var resource = this.getResource();
            return resource.formatHref({
                'assigning-authority': user.get('idType'),
                'patient-id': user.get('id'),
            });
        },

        /**
         * @param {Backbone.Model} lhs
         * @param {Backbone.Model} rhs
         * @return {number} lhs < rhs === -1, lhs === rhs 0, lhs > rhs === 1
         */
        comparator: function(lhs, rhs) {
            var lName = lhs.get('clinicName') || lhs.get('clinicFriendlyLocationName');
            var rName = rhs.get('clinicName') || rhs.get('clinicFriendlyLocationName');
            return lName.localeCompare(rName);
        },

        fetchClinics: function(parentFacilityCode, institutionCode, typeOfCare) {
            return this.fetch({
                data: {
                    'three-digit-code': parentFacilityCode,
                    'clinical-service': typeOfCare,
                    'institution-code': institutionCode,
                },
            });
        },

        /**
         * @param {string} parentFacilityCode
         * @param {array} institutionCodes
         * @param {string} typeOfCare
         * @return {array} a flattened collection of clinics across locations
         */
        fetchAllClinics: function(parentFacilityCode, institutionCodes, typeOfCare) {
            var clinicPromises = institutionCodes.map(function(institutionCode) {
                var clinicPromise = this.fetch({
                    data: {
                        'three-digit-code': parentFacilityCode,
                        'clinical-service': typeOfCare,
                        'institution-code': institutionCode,
                    },
                });
                return clinicPromise;
            }.bind(this));

            var returnValue = new $.Deferred();

            var count = institutionCodes.length;
            var result = [];
            var flattened;
            var addResult = function(toAdd) {
                result.push(toAdd);
                if (--count === 0) {
                    flattened = _.flatten(result);
                    returnValue.resolve(flattened);
                }
            };
            clinicPromises.forEach(function(clinicPromise) {
                clinicPromise.then(function(clinics) {
                    addResult(clinics);
                });
            });

            return returnValue;
        },

        toStringList: function() {
            var ids = this.pluck('clinicId');
            return ids.join(',');
        },
    });
});
